<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class UpgradeAccess
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        // Check if user is authenticated and is admin
        if (!auth()->check()) {
            return redirect('/login')->with('error', 'You must be logged in to access the upgrade system.');
        }
        
        // Check if user has admin role (adjust based on your role system)
        $user = auth()->user();
        
        if (!$user->hasRole('super-admin')) {
            return redirect('/')->with('error', 'You do not have permission to access the upgrade system.');
        }
        
        return $next($request);
    }
}